--[[
    "Scroller With Submenu" by Rhythm Lunatic
	tldr you can modify it, but others shall also be allowed to modify it. 

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
]]

--Custom func that returns dict with keys instead of a list
local function custSplit(delimiter, text)
	local list = {}
	local pos = 1
	while 1 do
		local first,last = string.find(text, delimiter, pos)
		if first then
			list[string.sub(text, pos, first-1)]=true
			pos = last+1
		else
			list[string.sub(text, pos)]=true
			break
		end
	end
	return list
end

local screenName = Var("LoadingScreen")
local wrapCursor = THEME:GetMetric(screenName,"WrapCursor")

--if you index by keys lua can't count without using a custom iterator
local choices = {};
for _,c in ipairs(STORYDATA.CHAPTER_ORDER) do
	local f = ResolveRelativePath("ScreenNonstopInterpreter overlay/"..c..".lua",1)
	--assert(f,c.." does not point to a valid map.");
	Trace("Loading chapter "..f)
	local chapterData,e = loadfile(f);
	assert(chapterData,e);
	chapterData = chapterData(...);
	assert(#chapterData > 0,c.." has no parts or points to a nonexistent file.");
	
	local submenu = {}
	for i,p in ipairs(chapterData) do
		submenu[#submenu+1] = {
			name=p['name'];
			FreeTime=p.FreeTime;
			--No need for this
			--gc='setenv,nextChapter,'..c..';setenv,nextPart,'..i;
		}
		if p.FreeTime then
			submenu[#submenu].screen='ScreenSelectMusicFreePlay';
		else
			submenu[#submenu].screen='ScreenNonstopInterpreter';
		end;
	end;
	
	choices[#choices+1] = {
		name=c;
		submenu=submenu;
	}
end;

assert(#choices > 0);

local maxNumCursorsToSpawn = 1

local mainMenuScroller;
local subMenuScrollers = {};
local subMenuScrollerActors = {}
local helperText;

local function updateCursor(scroller,pos)
	subMenuScrollerActors[mainMenuScroller:GetDestinationItem()+1]:playcommand("Hide");
	scroller:SetDestinationItem(pos)
	SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
	scroller:playcommand("Update");
	subMenuScrollerActors[mainMenuScroller:GetDestinationItem()+1]:playcommand("Show");
end;

local function updateCursorLuaScroller(scroller,scrollBy)
	scroller:scroll_by_amount(scrollBy);
end;

local inputLevel = 0;
local function inputHandler(event)

	local pn= event.PlayerNumber
	local button = event.button
	
	-- If it's a release, ignore it.
	if event.type == "InputEventType_Release" then return end

	if not pn then
		return 
	end
	
	
	if button == "Select" then
		SCREENMAN:SystemMessage(mainMenuScroller:GetNumItems())
		return
	end;
	
	if inputLevel == 0 then
		local curScroller = mainMenuScroller;
		if button == "MenuUp" or button == "MenuLeft" then
			if curScroller:GetDestinationItem() > 0 then
				updateCursor(curScroller, curScroller:GetDestinationItem()-1)
			elseif wrapCursor then 
				updateCursor(curScroller, curScroller:GetNumItems()-1)
			end;
		elseif button == "MenuDown" or button == "MenuRight" then
			if curScroller:GetDestinationItem() < curScroller:GetNumItems()-1 then
				updateCursor(curScroller, curScroller:GetDestinationItem()+1)
			elseif wrapCursor then
				updateCursor(curScroller, 0);
			end;
		elseif button == "Start" or button == "Center" then
			inputLevel = 1;
			subMenuScrollers[mainMenuScroller:GetDestinationItem()+1]:run_anonymous_function(function(self, info,is_focus)
				if is_focus then
					self.container:stoptweening():decelerate(.1):diffusealpha(1);
				end;
			end);
		elseif button == "Back" then
			if inputLevel == 1 then
				inputLevel=0;
			else
				SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen")
			end;
		else
			SCREENMAN:SystemMessage("unknown button: "..button);
		end;
	
		helperText:settext("Lv: "..inputLevel.." | C: "..curScroller:GetDestinationItem());
	else
		local curScroller = subMenuScrollers[mainMenuScroller:GetDestinationItem()+1];
		local idx = curScroller:get_current_index()
		local focus = curScroller.focus_pos-5
		if button == "MenuUp" or button == "MenuLeft" then
			if idx < 2 then return end;
			if focus > 0 then
				curScroller:move_focus_by(-1);
			else
				curScroller:scroll_by_amount(-1);
			end;
			--[[if idx > 1 then
				curScroller:scroll_by_amount(-1);
			end;]]
		elseif button == "MenuDown" or button == "MenuRight" then
			if idx < #choices[mainMenuScroller:GetDestinationItem()+1].submenu then
				--curScroller:scroll_by_amount(1);
				if focus < 2 then
					curScroller:move_focus_by(1);
				else
					curScroller:scroll_by_amount(1);
				end;
			end;
		elseif button == "Start" or button == "Center" then
			local c = choices[mainMenuScroller:GetDestinationItem()+1]['submenu'][idx]
			setenv('nextChapter',choices[mainMenuScroller:GetDestinationItem()+1].name);
			setenv('nextPart',idx);
			--if c.gc then GAMESTATE:ApplyGameCommand(c.gc) end;
			assert(c.screen,"No screen set for choice "..c.name);
			SCREENMAN:GetTopScreen():SetNextScreenName(c.screen)
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		elseif button == "Back" then
			--subMenuScrollerActors[mainMenuScroller:GetDestinationItem()+1]:playcommand("Hide");
			subMenuScrollers[mainMenuScroller:GetDestinationItem()+1]:run_anonymous_function(function(self, info,is_focus)
				if is_focus then
					self.container:stoptweening():decelerate(.1):diffusealpha(.5);
				end;
			end);
			inputLevel=0;
		else
			SCREENMAN:SystemMessage("unknown button: "..button);
		end;
		
		helperText:settext("Lv: "..inputLevel.." | C: "..curScroller:get_current_index().." | F: "..focus.." "..curScroller.focus_pos);
	end;
end;

--Scroller 1
local af = Def.ActorScroller{

	NumItemsToDraw=#choices*2, 
	SecondsPerItem=0,
	TransformFunction=THEME:GetMetric(screenName,"ScrollerTransform");

	InitCommand=cmd(xy,200,SCREEN_CENTER_Y;diffusealpha,1);
	OnCommand=function(self)
		mainMenuScroller = self;
		self:queuecommand("Show")
		self:GetChild(1):playcommand("GainFocus"):finishtweening();
	end;
	ShowCommand=function(self)
		self:diffusealpha(1);
	end;
	UpdateCommand=function(self)
		for i=1,#choices do			
			if self:GetDestinationItem() == i-1 then
				self:GetChild(i):playcommand("GainFocus")
			else
				--Trace(i)
				self:GetChild(i):playcommand("LoseFocus")
			end;
		end;
	end;
};

local function returnScroll(i,text)
	local HEIGHT = 30;
	return Def.ActorFrame {
		Name=i;
		--InitCommand=cmd(addy,i*50;diffusealpha,1);
		HideCommand=cmd(stoptweening;sleep,(i-1)/8;decelerate,.2;x,-200;diffusealpha,0);
		GainFocusCommand=cmd(linear,.1;x,-5;);
		LoseFocusCommand=cmd(linear,.1;x,5;);
		Def.ActorFrame{
		
			--Text background
			Def.Quad{
				InitCommand=cmd(setsize,250,30;diffuse,color("0,0,0,.6");halign,1;faderight,.5);

			};
			
			--BG
			Def.Quad{
				InitCommand=cmd(setsize,220,8;horizalign,right;diffuse,Color("Black");vertalign,bottom;addy,HEIGHT/2);
				OnCommand=cmd(x,5;addy,5);

			
			};
			parallelogramGen(HEIGHT,HEIGHT,Color("Black"))..{
				InitCommand=cmd(x,5;addy,5;);
			};
			
			--FG
			Def.Quad{
				InitCommand=cmd(setsize,220,3;horizalign,right;vertalign,bottom;addy,HEIGHT/2);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			
			};
			parallelogramGen(HEIGHT,HEIGHT,Color("White"))..{
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			};
		};
		
		--Text
		LoadFont("Dialogue Text")..{
			Name="Text";
			Text=text;
			InitCommand=cmd(shadowcolor,Color("Black");shadowlength,1;x,-100);
			GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
			LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
		};
		
	};
end;

for i,choice in ipairs(choices) do
	af[#af+1] = returnScroll(i,choice.name)..{ --It turns out using LoadActor wastes a ton of CPU cycles and disk access so now it's just a lua function
		InitCommand=cmd(draworder,300);
	}
end;

-- Scroller function thingy
local item_mt= {
  __index= {
	-- create_actors must return an actor.  The name field is a convenience.
	create_actors= function(self, params)
	  self.name= params.name
		return Def.ActorFrame{
			InitCommand= function(subself)
				-- Setting self.container to point to the actor gives a convenient
				-- handle for manipulating the actor.
		  		self.container= subself
		  		subself:SetDrawByZPosition(true);
		  		--subself:zoom(.75);
			end;
			OnCommand=cmd(draworder,5);
			Name=i;
			Def.Sprite{
				Texture="fbox";
				InitCommand=cmd(zoom,1.25;x,-3);
				GainFocusCommand=cmd(diffusealpha,1);
				LoseFocusCommand=cmd(diffusealpha,.5);
			};
			Def.Sprite{
				Name="Inside";
				Texture=THEME:GetPathB("StoryArea","overlay/Reimu");
				InitCommand=cmd(animate,false;zoom,.39;xy,3,55);
			};
			--[[Def.Sprite{
				Name="Inside";
				Texture=THEME:GetPathB("StoryArea","overlay/Iris");
				InitCommand=cmd(animate,false;zoom,.25);
			};]]
			LoadFont("Common Normal")..{
				Name='Text';
				InitCommand=cmd(horizalign,left;xy,-80,-143;draworder,15;maxwidth,80);
			};
			Def.ActorFrame{
				Name="FreeTime";
				InitCommand=cmd(xy,-3,130;);
				Def.Quad{
					InitCommand=cmd(diffuse,Color.Black;diffusetopedge,{0,0,0,0};setsize,164,100;vertalign,bottom;y,25);
				};
				LoadFont("Dialogue Character Names")..{
					Text="Free Time";
					InitCommand=cmd(diffusebottomedge,Color.Blue;xy,-3,10);
				};
			};
		};
	end,
	-- item_index is the index in the list, ranging from 1 to num_items.
	-- is_focus is only useful if the disable_wrapping flag in the scroller is
	-- set to false.
	transform= function(self, item_index, num_items, has_focus)
		local offsetFromCenter = item_index-math.floor(num_items/2)
		self.container:stoptweening();
		if math.abs(offsetFromCenter) < 5 then
			self.container:decelerate(.1)
			if offsetFromCenter >=0 then
				if inputLevel ==1 then
					self.container:diffusealpha(has_focus and 1 or .5);
				else
					self.container:diffusealpha(.5);
				end;
			else
				self.container:diffusealpha(0);
			end;
		else
			self.container:diffusealpha(0);
		end;
		self.container:x(200*offsetFromCenter);
		
	end,
	-- info is one entry in the info set that is passed to the scroller.
	set= function(self, info)
		if info then
			self.container:visible(true):GetChild("Text"):settext(info.name);
			self.container:GetChild('FreeTime'):visible(info.FreeTime == true);
		else
			self.container:visible(false);
		end;
	end,
}}

local t = Def.ActorFrame{
	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback(inputHandler);
		for i,choice in ipairs(choices) do
			if choice.submenu then
				--Trace(table_print(choice.submenu))
				--Trace("-------")
				subMenuScrollers[i]:set_info_set(choice.submenu,1);
				subMenuScrollers[i]:scroll_to_start();
				--subMenuScrollers[i].focus_pos = 5;
			end;
		end;
	end;
	LoadFont("Common Normal")..{
		Text=THEME:GetCurLanguage();
		InitCommand=cmd(Center)
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(CenterX;y,SCREEN_BOTTOM-10);
		OnCommand=function(self)
			helperText = self;
		end;
	};
}

for i,choice in ipairs(choices) do
	if choice.submenu then
		subMenuScrollers[i] = setmetatable({disable_wrapping= true}, item_scroller_mt)
		t[#t+1]=subMenuScrollers[i]:create_actors(i, 10, item_mt, SCREEN_CENTER_X-100,THEME:GetMetric(screenName,"SubScrollerY"))..{
			OnCommand=function(self)
				self:visible(i == 1);
				subMenuScrollerActors[i]=self;
			end;
			ShowCommand=cmd(visible,true);
			HideCommand=cmd(visible,false);
		}
	end;
end;

t[#t+1] = af;


return t;
